// CDĐXbh
#ifdef CDEMULATION

#include "stdinc.h"
#include "main.h"
#include "syscall.h"
#include "pg.h"
#include "string.h"
#include "sound.h"

typedef unsigned char byte;

#define  CDCMD_PLAY          1
#define  CDCMD_STOP          2
#define  CDCMD_PLAYRANGE     3


// Đthread̓tO|[OĒʐM󂯎B
// ĐthreadsleepĂꍇ̂wakeupsB
// ʐMKvȂ̂ : CDĐ / ~
int cd_req=0;     // cdNGXgtO
int cd_cmd=0;     // cdR}htO 1:play / 99:stop
int cd_track;     // ĐgbNԍ
int cd_fd =-1;    // CDĐ(WAVE/MP3?) File Handle
int cd_seek=0;

char* cdname(void)
{
    static char name[512];
    char trk[3];
    char * p;

    _strcpy(name,eConf.cdrom);
    p = _strrchr(name,'/');
    if(p) {
        *++p = (cd_track/10) + 0x30;
        *++p = (cd_track%10) + 0x30;
        *++p = '.';
        *++p = 'w';
        *++p = 'a';
        *++p = 'v';
        *++p = 0;
    }
    return name;
}


// play stop
int cd_PlayStop(void)
{
    cd_cmd = CDCMD_STOP;
    cd_req = 1;
    sceKernelWakeupThread(pga_threadhandle[1]);
    return 1;
}

// play start
int cd_PlayTrack(int track)
{
    cd_cmd   = CDCMD_PLAY;
    cd_track = track;
    cd_req   = 1;
    sceKernelWakeupThread(pga_threadhandle[1]);
    return 1;
}


// play with range
int cd_PlayWithRange( byte min_from, byte sec_from, byte fra_from,
                      byte min_to,   byte sec_to,   byte fra_to)
{
    
    sceKernelWakeupThread(pga_threadhandle[1]);
    return 1;
}

//------------------------------------------------------------------------------
// CD Playter Thread
//------------------------------------------------------------------------------
static char cdwave[1024*4];

void* wavout_snd1_callback(short *buf, unsigned long reqn)
{
    int len;

    for(;;) {
        if( cd_req ) {
            switch(cd_cmd) {
              case CDCMD_STOP:
                if(cd_fd) {
                    sceIoClose(cd_fd);
                    cd_fd=-1;
                }
                break;
                
              case CDCMD_PLAYRANGE:
              case CDCMD_PLAY:
                cd_seek = 0;
                if(cd_fd) {
                    sceIoClose(cd_fd);
                    cd_fd=-1;
                }
                cd_fd = sceIoOpen(cdname(),O_RDONLY,0777);
                break;
            }

            // V[N
            if(cd_cmd==CDCMD_PLAYRANGE) {
                cd_req = 0;
            }

            cd_req=0;
        }

        if(cd_fd>=0){
            len = sceIoRead(cd_fd,cdwave,reqn*2*2);
//            if(len!=reqn*2*2) {
//                sceIoLseek(cd_fd,0,0);
//            }
            return cdwave;
        }
        
        sceKernelSleepThread();
    }
    
    return 0;
}

void dbgCDPlay(void)
{
    mh_print_hex8( 0,220, cd_fd   , RGB_WHITE);
    mh_print_hex8( 0,230, cd_cmd  , RGB_WHITE);
    mh_print_hex8( 0,240, cd_track, RGB_WHITE);
    mh_print_hex8( 0,250, cd_req  , RGB_WHITE);
    mh_print     ( 0,260, cdname(), RGB_WHITE);
    
}

#endif// CDEMULATION




